#!/bin/bash

# Update script to pull latest or specified version images from Docker Hub
# Usage: ./update.sh [version]
# If version is not provided, pulls 'latest' tag

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Docker Hub repository
DOCKER_REPO="aidaplatform"
PROJECT_NAME="aida-eap-tls-provisioning"

# Get version
if [ -z "$1" ]; then
    VERSION="latest"
    echo -e "${GREEN}Pulling latest images...${NC}"
else
    VERSION="$1"
    echo -e "${GREEN}Pulling images for version: ${VERSION}${NC}"
fi

# Check if Docker is running
if ! docker info > /dev/null 2>&1; then
    echo -e "${RED}Error: Docker is not running${NC}"
    exit 1
fi

# Pull images
echo -e "${GREEN}Pulling backend image...${NC}"
docker pull ${DOCKER_REPO}/${PROJECT_NAME}-backend:${VERSION} || {
    echo -e "${RED}Failed to pull backend image${NC}"
    exit 1
}

echo -e "${GREEN}Pulling frontend image...${NC}"
docker pull ${DOCKER_REPO}/${PROJECT_NAME}-frontend:${VERSION} || {
    echo -e "${RED}Failed to pull frontend image${NC}"
    exit 1
}

echo -e "${GREEN}Pulling freeradius image...${NC}"
docker pull ${DOCKER_REPO}/${PROJECT_NAME}-freeradius:${VERSION} || {
    echo -e "${RED}Failed to pull freeradius image${NC}"
    exit 1
}

# Tag as latest if specific version was pulled
if [ "$VERSION" != "latest" ]; then
    echo -e "${GREEN}Tagging images as latest...${NC}"
    docker tag ${DOCKER_REPO}/${PROJECT_NAME}-backend:${VERSION} ${DOCKER_REPO}/${PROJECT_NAME}-backend:latest
    docker tag ${DOCKER_REPO}/${PROJECT_NAME}-frontend:${VERSION} ${DOCKER_REPO}/${PROJECT_NAME}-frontend:latest
    docker tag ${DOCKER_REPO}/${PROJECT_NAME}-freeradius:${VERSION} ${DOCKER_REPO}/${PROJECT_NAME}-freeradius:latest
fi

echo -e "${GREEN}✓ All images updated successfully!${NC}"
echo -e "${YELLOW}Note: Run './start.sh' to restart containers with new images${NC}"

