#!/bin/bash

# Stop script to stop all containers
# Usage: ./stop.sh

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Detect docker compose command
if docker compose version &> /dev/null; then
    DOCKER_COMPOSE="docker compose"
elif command -v docker-compose &> /dev/null; then
    DOCKER_COMPOSE="docker-compose"
else
    echo -e "${RED}Error: Docker Compose is not installed${NC}"
    exit 1
fi

echo -e "${GREEN}Stopping EAP-TLS Provisioning services...${NC}"

# Stop services
$DOCKER_COMPOSE down

echo -e "${GREEN}✓ Services stopped successfully!${NC}"

