#!/bin/bash

# Logs script to show the logs of the Docker containers
# Usage: ./logs.sh

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Detect docker compose command
if docker compose version &> /dev/null; then
    DOCKER_COMPOSE="docker compose"
elif command -v docker-compose &> /dev/null; then
    DOCKER_COMPOSE="docker-compose"
else
    echo -e "${RED}Error: Docker Compose is not installed${NC}"
    exit 1
fi

echo -e "${GREEN}Showing logs for EAP-TLS Provisioning services...${NC}"

# Show logs for all services
$DOCKER_COMPOSE logs -f

echo -e "${GREEN}✓ Logs shown successfully!${NC}"

echo -e "${YELLOW}Note: Run '$DOCKER_COMPOSE logs -f' to view logs${NC}"

