#!/bin/bash

# Check if script is run as root
if [ "$EUID" -ne 0 ]; then
    echo "Please run this script with sudo:"
    echo "sudo ./uninstall.sh"
    exit 1
fi

echo "=== Inspextor Architect Uninstallation Started $(date) ==="

# Stop the application if running
echo "Stopping Inspextor Architect services..."
if [ -f "/opt/inspextor_architect/stop.sh" ]; then
    cd /opt/inspextor_architect
    ./stop.sh
fi

# Disable and remove systemd service
echo "Removing systemd service..."
systemctl disable inspextor-architect.service 2>/dev/null || true
systemctl stop inspextor-architect.service 2>/dev/null || true
rm -f /etc/systemd/system/inspextor-architect.service
systemctl daemon-reload

# Remove crontab entries
echo "Removing crontab entries..."
(crontab -l 2>/dev/null | grep -v "inspextor_architect") | crontab -

# Remove application files
echo "Removing application files..."
if [ -d "/opt/inspextor_architect" ]; then
    rm -rf /opt/inspextor_architect
    echo "✓ Removed /opt/inspextor_architect"
fi

# Remove log files (optional - uncomment if you want to remove logs)
# echo "Removing log files..."
# rm -f /var/log/run_script_startup.log
# rm -f /var/log/host_controller_startup.log
# rm -f /var/log/inspextor_architect_install.log
# rm -rf /var/log/inspextor_architect

echo "=== Uninstallation Complete ==="
echo "✓ Inspextor Architect has been removed from the system"
echo "✓ Note: Docker images and PostgreSQL data remain intact"
echo "  To completely clean up, you may also want to:"
echo "  - Remove Docker images: docker rmi inspextor/architect inspextor/architect-backend"
echo "  - Remove PostgreSQL database: sudo -u postgres dropdb inspextor_architect"
echo "" 