#!/bin/bash

# Check if .env exists, if not copy from .env.example
if [ ! -f ".env" ]; then
    echo "Creating .env file from env.example..."
    cp env.example .env
    echo "Created .env file"
else
    echo ".env file already exists"
fi

# Restart the server
./restart.sh

echo "Services started. To check logs, use:"
echo "  docker compose -f docker-compose.prod.yml logs -f    # All services"
echo "  docker compose -f docker-compose.prod.yml logs -f backend    # Backend only"
echo "  docker compose -f docker-compose.prod.yml ps         # Check service status"
echo "  docker compose -f docker-compose.prod.yml restart backend    # Restart backend"


