#!/bin/bash

# Restart all containers
# docker compose -f docker-compose.prod.yml restart

# Stop any running containers
echo "Stopping the server..."

# Check if containers are running and stop them
if docker ps --format "table {{.Names}}" | grep -q "inspextor_architect"; then
    echo "Found running containers, stopping them..."
    docker compose -f docker-compose.prod.yml down
else
    echo "No running containers found."
fi

# Read APP_VERSION from file, default to latest
APP_VERSION=$(cat /opt/inspextor_architect/APP_VERSION 2>/dev/null || echo "latest")

echo "Starting services with version: $APP_VERSION"

# Create temporary env file
echo "APP_VERSION=$APP_VERSION" > /tmp/docker-compose.env

# Build services with env file
# echo "Building services..."
# docker compose -f docker-compose.prod.yml --env-file /tmp/docker-compose.env build --no-cache

# Start services with env file
docker compose -f docker-compose.prod.yml --env-file /tmp/docker-compose.env up -d

# Clean up
rm /tmp/docker-compose.env

# Wait a moment for containers to start
sleep 3

# Show running versions
echo "Services restarted."
echo "Running versions:"
echo "Frontend version:"
docker inspect inspextor_architect-frontend-1 --format '{{.Config.Labels.version}}' 2>/dev/null || echo "Frontend not running"
echo "Backend version:"
docker inspect inspextor_architect-backend-1 --format '{{.Config.Labels.version}}' 2>/dev/null || echo "Backend not running"