#!/bin/bash

frontend_repo="inspextor/architect"
backend_repo="inspextor/architect-backend"

# Get APP_VERSION from command line argument, default to "latest"
APP_VERSION=${1:-"latest"}

# Save APP_VERSION to file
echo "$APP_VERSION" > /opt/inspextor_architect/APP_VERSION

echo "Pulling version: $APP_VERSION"

# Pull specified version
docker pull $frontend_repo:$APP_VERSION
docker pull $backend_repo:$APP_VERSION

# Show versions
echo "Frontend version:"
docker inspect $frontend_repo:$APP_VERSION --format '{{.Config.Labels.version}}'
echo "Backend version:"
docker inspect $backend_repo:$APP_VERSION --format '{{.Config.Labels.version}}'