#!/bin/bash

# Check database connection using a direct connection test
# if ! docker compose -f docker-compose.prod.yml exec backend python3 -c "from db import check_connection; exit(0 if check_connection() else 1)"; then
#     echo "Database is not up"
#     exit 1
# fi

echo "Upgrading database..."
docker compose -f docker-compose.prod.yml exec backend python3 manage_db.py upgrade

# if the argument is not empty, run the migrate command
if [ -n "$1" ]; then
    echo "Migrating database..."
    docker compose -f docker-compose.prod.yml exec backend python3 manage_db.py migrate "$1"
    docker compose -f docker-compose.prod.yml exec backend python3 manage_db.py upgrade
    echo "Database migrated and upgraded"
else
    echo "Database upgraded"
fi


