#!/bin/bash

# Wait for Avahi to be ready
sleep 5

SERVER_IP=$(hostname -I | awk '{print $1}')
echo "$(date): Publishing architect.local to Avahi with IP: $SERVER_IP"

# Kill any existing avahi-publish processes for architect.local
pkill -f "avahi-publish.*architect.local" || true

# Publish the address
avahi-publish -a -R architect.local $SERVER_IP &
AVAHI_PID=$!

# Save PID for potential cleanup
echo $AVAHI_PID > /var/run/avahi-publish-architect.pid

echo "$(date): Avahi publish started with PID: $AVAHI_PID"